implementation module EdEditMenu;

/*	The commands of the Edit menu */

import StdClass,StdInt, StdBool, StdString, StdMisc,StdArray,StdChar;
import deltaDialog, deltaControls;
import UtilNewlinesFile /*, UtilDiagnostics */;

import	EdProgramState, EdDialogs, EdSupport, EdSearchMenu, EdWindows,
		EdLists, EdTextWindow, EdDrawWindow, EdMenuItems, EdTextFind, EdCleanSystem;

from EdCleanSystem import GetClipboardText;

(AP2) infixr;
(AP2) f g :== f e1 e2; { (e1,e2) = g };

//	Device function for the Undo command

Undo :: !ProgState !IO -> ProgIO;
Undo prog=:{editor={editwindows}} io
	| replaced_all						= UndoReplaceAll undo frontid front prog io;
	| not_removed && not_added && clip	= UndoCopy undo frontid front prog io;
	| not_removed && not_added && find	= UndoFind undo frontid front prog io;
	| not_removed && not_added			= (prog,io);
										= UndoReplace undo frontid front prog io;
	where {
	(frontid,front)	= GetFrontWindow editwindows;
	replaced_all	= not (IsEmptyList replaced.ln_cns);
	find			= not (clipcopied.pos.l1 == (-1) || clipcopied.pos.c1 == (-1));
	not_added		= added.l1 == added.l2  &&  added.c1 == added.c2;
	not_removed		= removed.Removed.lnr == (-1)  &&  removed.Removed.cnr == (-1);
	clip			= clipcopied.clipset;
	clipcopied		= undo.UndoInfo.clipcopied;
	removed			= undo.UndoInfo.removed;
	replaced		= undo.UndoInfo.replaced;		
	added			= undo.UndoInfo.added;
	undo			= front.wstate.undoinfo;
	};

/* Undoes the Replace All command */
	
UndoReplaceAll :: !UndoInfo !EditWdId !EditWindow !ProgState !IO -> ProgIO;
UndoReplaceAll undoinfo=:{replaced} frontid front prog=:{editor=ed=:{editwindows}} io
	= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollHalfWin wu prog1 io;
	where {
	prog1						= {prog & editor={ed & editwindows=editwindows`}};
	(front1,fnd,replaced,wu)	= ReplaceAllInText front (Text_UndoReplaceAll undoinfo.replaced);
	front` | fnd				= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
								= front1;
	editwindows`				= SetFrontWindow front` editwindows;
	undoinfo`					= UndoInfoUndoReplaceAll replaced (front.wstate.undoinfo);
	};

/* Determines undo info after an Undo Replace All */

UndoInfoUndoReplaceAll :: !ReplacedAll !UndoInfo -> UndoInfo;
UndoInfoUndoReplaceAll replaced undoinfo=:{menu=men=:{undo}}
	= { undoinfo & replaced = replaced, menu = {men & undo = not undo} };

/*	Undoes the Copy command. */
	
UndoCopy :: !UndoInfo !EditWdId !EditWindow !ProgState !IO -> ProgIO;
UndoCopy	undoinfo=:{clipcopied={clipboard,pos},menu={undo}}
			frontid front=:{wstate}
			prog=:{editor=ed=:{editwindows,clipboard=clip}} io
	| undo	= UpdateGlobalClipboardAndClipboardWindow clipboard AP2 DrawSelection True frontid front` pos prog2 io2;
			= UpdateGlobalClipboardAndClipboardWindow clipboard prog2 io2;
	where {
	(prog2,io2)		= Edit_UpdateMenuItems prog1 io;
	prog1			= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`	= SetFrontWindow front` editwindows;
	front`			= {front & wstate = {wstate & undoinfo = undoinfo`}};
	undoinfo`		= UndoInfoUndoCopy clip undoinfo;
	};

/* Determines undo info after an Undo Copy operation. */

UndoInfoUndoCopy :: !Clipboard !UndoInfo -> UndoInfo;
UndoInfoUndoCopy clip undoinfo=:{clipcopied,menu=men=:{undo}}
	= { undoinfo &	menu		= { men & undo = not undo },
					clipcopied	= { ClipCopied | clipcopied & clipboard = clip } };
					
/*	Undoes the Find command. */
	
UndoFind :: !UndoInfo !EditWdId !EditWindow !ProgState !IO -> ProgIO;
UndoFind	undoinfo=:{clipcopied={pos},menu={undo}}
			frontid front=:{wtext={curline,selection}}
			prog=:{editor=ed=:{editwindows}} io
	= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollHalfWin wu prog1 io;
	where {
	prog1			= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`	= SetFrontWindow front` editwindows;
	textpos			= EW_GetTextPosition curline selection;
	(front1,wu)		= SelectText front pos;
	front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
	undoinfo`		= UndoInfoUndoFind textpos undoinfo;
	};

/* Determines undo info after an Undo Copy operation. */

UndoInfoUndoFind :: !PartTSel !UndoInfo -> UndoInfo;
UndoInfoUndoFind textpos undoinfo=:{clipcopied,menu=men=:{undo}}
	= { undoinfo &	menu		= { men & undo = not undo },
					clipcopied	= { clipcopied & pos = textpos } };

/*	Undoes/Redoes Cut, Clear, Paste and Replace commands and Typings */

UndoReplace :: !UndoInfo !EditWdId !EditWindow !ProgState !IO -> ProgIO;
UndoReplace	undoinfo=:{clipcopied={clipset,clipboard},added,removed,menu}
			frontid front
			prog=:{editor=ed=:{editwindows,clipboard=clip}} io
	| clipset	= UpdateGlobalClipboardAndClipboardWindow clipboard prog1 io1;
				= (prog1,io1);
	where {
	(prog1,io1)		= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollHalfWin wu prog0 io;
	prog0			= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`	= SetFrontWindow front` editwindows;
	(front1,wu)		= ReplaceText True front added rclip;
	front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
	undoinfo`		= UndoInfoUndoReplace clip wu undoinfo;
	rclip			= RemovedToClipboard removed;
	};

/* Determines undo info after an Undo Cut, Clear, Paste, Replace, Undo Typing operation. */
	
UndoInfoUndoReplace :: !Clipboard !WindowUpdate !UndoInfo -> UndoInfo;
UndoInfoUndoReplace clip	wu=:{ WindowUpdate | removed, added=add=:{l1,c1} }
							undoinfo=:{ clipcopied=clipc=:{clipset,clipboard}, menu=men=:{undo} }
	| clipset	= { undoinfo` & clipcopied = {ClipCopied | clipc & clipboard = clip} };
				= undoinfo`;
	where {
	undoinfo`	= { EmptyUndo &	removed	= { Removed | EmptyRemoved &
													before	= removed,
													lnr		= l1,
													cnr		= c1 },
								added	= add,
								menu 	= {men & undo = not undo } };
	};
	
//	Device function for the Cut command
	
Cut :: !ProgState !IO -> ProgIO;
Cut prog=:{editor=ed=:{editwindows}} io0
	= Edit_UpdateMenuItems
		AP2 UpdateGlobalClipboardAndClipboardWindow wu.WindowUpdate.removed
		AP2 DrawTextUpdate frontid ScrollHalfWin wu prog0 io1;
	where {
		prog0			= {prog & editor={ed & editwindows=editwindows`}};
		editwindows`	= SetFrontWindow front` editwindows;
		(frontid,front)	= GetFrontWindow editwindows;
		(front1,wu)		= RemoveText front selection.tsel;
		front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
		selection		= front.wtext.WinText.selection;
		undoinfo`		= UndoInfoCut selection wu.WindowUpdate.removed clipboard;
	
  (clipboard,io1) = GetClipboard ed.Editor.clipboard io0;
	};

GetClipboardFromScrap :: IO -> (!Clipboard,!IO);
GetClipboardFromScrap io0 
// RWS ... the string_to_strict_list_of_strings below always appends an empty string
//         which is what the editor expects (don't know why)
//
//	= (string_to_strict_list_of_strings 0 string, io1);	{
	= (clipboard, io1);	{

//	fix the case where the clipboard was empty
		clipboard
			=	case (string_to_strict_list_of_strings 0 string) of
				{
					("" :! Nil)
						-> Nil;
					list
						-> list;
				};
// ... RWS

		(string,io1) =  GetClipboardText io0;
		
		string_to_strict_list_of_strings :: Int String -> List String;
		string_to_strict_list_of_strings i s
// RWS ...
//			| position > i
//				= s % (i,position) :! Nil;
//				= Nil
// ... RWS
			| position>= size s
				=  s % (i,position) :! Nil;
				=  s % (i,position) :! string_to_strict_list_of_strings (inc position) s;
			where
			{
				position=find_newline_in_string i s;
				
				find_newline_in_string i s
					| i>= size s || s.[i]=='\n'
						= i;
						= find_newline_in_string (inc i) s;						
			}
	}

/* Determines undo info after a Cut operation. */

UndoInfoCut	:: !Selection !Clipboard !Clipboard -> UndoInfo;
UndoInfoCut selection=:{tsel=sel=:{l1,c1}} removed oldclip
//	= EmptyUndo;
	= { EmptyUndo &	clipcopied	= {	clipset		= True,
									clipboard	= oldclip,
									pos			= sel },
					removed		= { Removed |
										before	= removed,
										after	= Nil,
										lnr		= l1,
										cnr		= c1 },
					added		= { l1 = l1, c1 = c1, l2 = l1, c2 = c1},
					menu		= { undo = True, action = " Cut" } };

//	Device function for the Copy command
	
Copy :: !ProgState !IO -> ProgIO;
Copy prog=:{editor=ed=:{editwindows}} io0
	= Edit_UpdateMenuItems AP2 UpdateGlobalClipboardAndClipboardWindow clip prog1 io1;
	where {
		prog1			= {prog & editor={ed & editwindows=editwindows`}};
		editwindows`	= SetFrontWindow front` editwindows;
		(_,front)		= GetFrontWindow editwindows;
		(front1,clip)	= CopyText front selection.tsel;
		front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
		selection		= front.wtext.WinText.selection;
		undoinfo`		= UndoInfoCopy selection clipboard;
	
  (clipboard,io1) = GetClipboard ed.Editor.clipboard io0;
	};

GetClipboard clipboard io
	:== IfUnixSystem
								(clipboard, io)
								(GetClipboardFromScrap io);
	
/* Determines undo info after a Cut operation. */
	
UndoInfoCopy :: !Selection !Clipboard -> UndoInfo;
UndoInfoCopy selection=:{tsel} clipboard
	= { EmptyUndo & 
			clipcopied	= { 	clipset		= True,
								clipboard	= clipboard,
								pos			= selection.tsel },
			menu		= {undo = True,action = " Copy"} };

// Device function for the Paste Command
	
Paste :: !ProgState !IO -> ProgIO;
Paste prog=:{editor=ed=:{editwindows}} io0
	= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollHalfWin wu prog1 io1;
	where {
	prog1			= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`	= SetFrontWindow front` editwindows;
	(frontid,front)	= GetFrontWindow editwindows;
	(front1,wu)		= front1_wu;
	front1_wu | has_selection
					= ReplaceText False front selection.tsel clipboard;
					= InsertText False front cline.CurLine.lnr cline.CurLine.cnr clipboard;
	front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
	undoinfo`		= UndoInfoPaste wu;
	selection		= front.wtext.WinText.selection;
	cline			= front.wtext.curline;
	has_selection	= not (IsEmptySelection selection);
	
  (clipboard,io1) = GetClipboard ed.Editor.clipboard io0;
	};

/* Determines undo info after a Cut operation. */
	
UndoInfoPaste :: !WindowUpdate -> UndoInfo;
UndoInfoPaste {WindowUpdate | added=add=:{l1,c1},removed}
	= { EmptyUndo &	menu	= { undo = True, action = " Paste" },
					added	= add,
					removed	= { Removed | EmptyRemoved &
									before	= removed,
									lnr		= l1,
									cnr		= c1 } };

//
//	Device function for the Clear command
//

Clear :: !ProgState !IO -> ProgIO;
Clear prog=:{editor=ed=:{editwindows}} io
	= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollHalfWin wu prog1 io;
	where {
	prog1			= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`	= SetFrontWindow front` editwindows;
	(frontid,front)	= GetFrontWindow editwindows;
	(front1,wu)		= RemoveText front selection.tsel;
	front`			= {front1 & wstate = {front1.wstate & undoinfo = undoinfo`}};
	undoinfo`		= UndoInfoClear selection wu.WindowUpdate.removed;
	selection		= front.wtext.WinText.selection;
	};

/* Determines undo info after a Cut operation. */

UndoInfoClear :: !Selection !Clipboard -> UndoInfo;
UndoInfoClear {tsel=sel=:{l1,c1}} clip
	= { EmptyUndo & menu		= { undo = True, action = " Clear" },
					added		= { sel & l2 = l1, c2 = c1 },
					removed		= { Removed |
										before	= clip,
										after	= Nil,
										lnr		= l1,
										cnr		= c1 } };

//
//	Device function for the Balance command
//

Balance	:: !ProgState !IO -> ProgIO;
Balance prog=:{editor=ed=:{editwindows}} io
	| fnd	= DrawSelection False frontid front` tsel prog` io;
			= (prog`, Alert io);
	where {
	prog`			= {prog & editor={ed & editwindows=editwindows}};
	(front`,_,text)	= GetText front;
	(frontid,front)	= GetFrontWindow editwindows;
	(fnd,tsel)		= Text_Balance textpos.l1 textpos.c1 textpos.l2 textpos.c2 text;
	textpos			= EW_GetTextPosition front.wtext.curline front.wtext.WinText.selection;
	};

//	Device function for the Select All command

SelectAll :: !ProgState !IO -> ProgIO;
SelectAll prog=:{editor=ed=:{editwindows}} io
	=  Edit_UpdateMenuItems AP2 DrawTextUpdate frontid ScrollNone wu prog1 io;
	where {
	prog1				= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`		= SetFrontWindow front` editwindows;
	(frontid,front)		= GetFrontWindow editwindows;
	(front`,wu)			= SelectAllText front;
	};	
	
/* Aux function: Sets and draws actual selection.
*/

DrawSelection :: !Bool !EditWdId !EditWindow !PartTSel !ProgState !IO -> ProgIO;
DrawSelection goto_cursor frontid front tsel prog=:{editor=ed=:{editwindows}} io
	= Edit_UpdateMenuItems AP2 DrawTextUpdate frontid scroll wu prog1 io;
	where {
	prog1					= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`			= SetFrontWindow front` editwindows;
	(front`,wu)				= SelectText front tsel;
	scroll | goto_cursor	= ScrollHalfWin;
							= ScrollNone;
	};


//
//	Device function for the Format dialog
//

	PFontID		:== 1;
	PSFontID	:== 2;
	PSizeID		:== 3;
	PSSizeID	:== 4;
	PFoxID		:== 5;
	PETabWID	:== 6;		PSTabWID	:== 7;
	PSAutoID	:== 8;		PBAutoID	:== 9;
	PUseAID		:== 11;		PUseDID		:== 12;		PCancID	:== 13;	POKID	:== 14;
	IFontID		:== 2000;	ISizeID		:== 4000;

	PSNewLinesID	:== 20;
	PSNewLineConventionID	:== 21;
	RMacID	:== 22;
	RUnixID	:== 23;
	RDosID	:== 24;
	
    
Format	:: !ProgState !IO -> ProgIO;
Format prog=:{editor={editwindows}} io =  OpenModalDialog dialog prog io;
	where {
	dialog= CommandDialog DFormatID "Format" [ItemSpace (Pixel 12) (Pixel 6)] POKID [
				StaticText PSFontID Left "Font:",
				ScrollingList PFontID (XOffset PSFontID (MM 1.0)) (MM 0.0) Able 5
			                                    winfont.WindowFont.fontname
			                                    MakeFontItems
			                                    ChangeFormatSizesList,
				StaticText PSSizeID (RightTo PFontID) "Size:",
				ScrollingList PSizeID (XOffset PSSizeID (MM 1.0)) (MM 10.0) Able 5
			                                    (toString winfont.WindowFont.fontsize)
			                                    (MakeSizeItems winfont.WindowFont.fontname)
			                                    ChangeFormatLazyFox,
				DialogIconButton PFoxID Left ((0,0),FoxDim)
			                                    (LazyFox winfont.WindowFont.fontname
			                                    	winfont.WindowFont.fontsize)
												Unable
												ButIdle,
				StaticText PSNewLinesID Left "NewLines:",
				RadioButtons PSNewLineConventionID (RightTo PSNewLinesID) (Columns 3) newlineId
			    	[
						RadioItem RMacID	"Mac"	Able DFIdle,
						RadioItem RUnixID	"Unix"	Able DFIdle,
						RadioItem RDosID	"DOS"	Able DFIdle
					],
				CheckBoxes PSAutoID Left (Columns 1)
			             [CheckBox PBAutoID "Auto Indent" Able autoimark DFIdle],
				StaticText PSTabWID (RightTo PSAutoID) "Tab Width:",
				EditText   PETabWID (XOffset PSTabWID (MM 1.0)) (MM 10.0) 1 (toString tab.ttabw),
				DialogButton PUseAID (YOffset PSAutoID (Pixel 12)) "Use Default Settings"
				                                                     	   Able SetToDefaults,
				DialogButton PCancID (XOffset PUseAID (Pixel 40)) "Cancel" Able Cancel,
				DialogButton PUseDID (YOffset PUseAID (Pixel 12)) "  Use As Defaults  "
				                                                           Able (FormatOK True),
				DialogButton POKID   (YOffset PCancID (Pixel 12)) "OK"     Able (FormatOK False) ];
	autoimark		= BoolToMark autoind;
	(_,front)		= GetFrontWindow editwindows;
	winfont			= front.wformat.winfont;
	tab				= front.wformat.tabw;
	autoind			= front.wformat.WinFormat.autoi;
	newlineId		= NewLinesToID front.wformat.WinFormat.newlines;
	};

NewLinesToID :: NewlineConvention -> Int;
NewLinesToID NewlineConventionMac
	=	RMacID;
NewLinesToID NewlineConventionUnix
	=	RUnixID;
NewLinesToID NewlineConventionDos
	=	RDosID;
NewLinesToID _
	=	NewLinesToID HostNativeNewlineConvention;

IDToNewLines :: Int -> NewlineConvention;
IDToNewLines RMacID
	=	NewlineConventionMac;
IDToNewLines RUnixID
	=	NewlineConventionUnix;
IDToNewLines RDosID
	=	NewlineConventionDos;
IDToNewLines _
	=	HostNativeNewlineConvention;

SetToDefaults :: !DialogInfo !ProgState !IO -> ProgIO;
SetToDefaults dialog prog=:{editor={editwindows,defaults}} io
	| same_font && same_size	=  (prog, ChangeDialog DFormatID changes io);
	| same_font					=  (prog, ChangeDialog DFormatID [setsize : changes] io);
								=  (prog, ChangeDialog DFormatID [setfont,setsize : changes] io);
	where {
	setfont			= ChangeScrollingList	PFontID
											eo.EditOptions.fontname
											MakeFontItems;
	setsize			= ChangeScrollingList	PSizeID
											(toString eo.EditOptions.fontsize)
											(MakeSizeItems eo.EditOptions.fontname);
	changes			= [	ChangeIconLook PFoxID
								(LazyFox	eo.EditOptions.fontname
											eo.EditOptions.fontsize),
					 		 	ChangeEditText PETabWID (toString eo.tabs),
					 		 	ChangeAutoIndentOption eo.EditOptions.autoi,
					 		 	ChangeNewLinesOption eo.EditOptions.newlines];
	same_font		= eo.EditOptions.fontname == oldopt.EditOptions.fontname;
	same_size		= eo.EditOptions.fontsize == oldopt.EditOptions.fontsize;
	eo				= GetDefaultWindowOptions front.wstate.wdtype defaults;
	(_,front)		= GetFrontWindow editwindows;
	oldopt			= GetFormatDialogInfo dialog;
	};

ChangeAutoIndentOption :: !Bool !(DialogState ProgState IO) -> DialogState ProgState IO;
ChangeAutoIndentOption auto dstate
	| auto	=  MarkCheckBoxes   [PBAutoID] dstate;
			=  UnmarkCheckBoxes [PBAutoID] dstate;

ChangeNewLinesOption :: !NewlineConvention !(DialogState ProgState IO) -> DialogState ProgState IO;
ChangeNewLinesOption newLines dstate
	=	SelectDialogRadioItem (NewLinesToID newLines) dstate;

FormatOK :: !Bool !DialogInfo !ProgState !IO -> ProgIO;
FormatOK use_as_default dialog prog=:{editor=ed=:{project,editwindows,defaults}} io
	| use_as_default	=  ChangeWindowSettings newdefs frontid front prog` io;
						=  ChangeWindowSettings newdefs frontid front prog io;
	where {
	prog` | editwd		= {prog & editor={ed & defaults=newdefaults,project=project}};
						= {prog & editor={ed & defaults=newdefaults}};
	editwd				= wdtype == EditWd;
	(frontid,front)		= GetFrontWindow editwindows;
	wdtype				= front.wstate.wdtype;
	newdefs				= GetFormatDialogInfo dialog;
	newdefaults			= SetDefaultWindowOptions wdtype newdefs defaults;
	};
	
GetDefaultWindowOptions :: !WdType !Defaults -> EditOptions;
GetDefaultWindowOptions wdtype {edit,types,errors,clip,dproject}
	= case wdtype of
		{	ErrorWd		-> errors.eo;
			TypeWd		-> types.eo;
			EditWd		-> edit.eo;
			ProjectWd	-> dproject.eo;
			ClpbrdWd	-> clip.eo;
		};
	
SetDefaultWindowOptions :: !WdType !EditOptions !Defaults -> Defaults;
SetDefaultWindowOptions wdtype	opt defaults=:{edit,types,errors,clip,dproject}
	= case wdtype of
		{	ErrorWd		-> {Defaults | defaults & errors={errors & eo=opt}};
			TypeWd		-> {Defaults | defaults & types={types & eo=opt}};
			EditWd		-> {Defaults | defaults & edit={edit & eo=opt}};
			ProjectWd	-> {Defaults | defaults & dproject={dproject & eo=opt}};
			ClpbrdWd	-> {Defaults | defaults & clip={clip & eo=opt}};
		};

ChangeWindowSettings :: !EditOptions !EditWdId !EditWindow !ProgState !IO -> ProgIO;
ChangeWindowSettings	{EditOptions | autoi,newlines,tabs,fontname,fontsize}
						frontid front=:{wformat=wf=:{tabw,winfont}}
						prog=:{editor=ed=:{editwindows}} io
	| sametabs_and_font_and_size	= (prog`,io`);
									= DrawUpdateWindow frontid change_win prog` io`;
	where {
	io`							= CloseActiveDialog io;
	prog`						= {prog & editor={ed & editwindows=editwindows`}};
	editwindows`				= SetFrontWindow front` editwindows;
	change_win					= SetTab_and_Font_and_Size tabs fontname fontsize;
	sametabs_and_font_and_size	= fontname == winfont.WindowFont.fontname &&
									fontsize == winfont.WindowFont.fontsize &&
										tabs == tabw.ttabw;
	same_newline_convention		= newlines == wf.WinFormat.newlines;
	front`						= {front & wformat = {WinFormat | wf & autoi = autoi, newlines = newlines},
										 wstate.saved = front.wstate.saved && same_newline_convention};
	};

GetFormatDialogInfo	:: DialogInfo -> EditOptions;
GetFormatDialogInfo dialog
	= { DefaultEditOptions & 	
		tabs		= Between 1 99 (StringToInt (GetEditText PETabWID dialog)),
		fontname	= GetScrollingListItem PFontID dialog,
		fontsize	= StringToInt (GetScrollingListItem PSizeID dialog),
		autoi		= CheckBoxMarked PBAutoID dialog,
		newlines	= IDToNewLines (GetSelectedRadioItemId PSNewLineConventionID dialog)};

ChangeFormatSizesList :: !DialogInfo !(DialogState ProgState IO) -> DialogState ProgState IO;
ChangeFormatSizesList ddef dstate
	=  ChangeSizesList PFoxID PSizeID (GetFormatDialogInfo ddef) dstate;

ChangeFormatLazyFox	:: !DialogInfo !(DialogState ProgState IO) -> DialogState ProgState IO;
ChangeFormatLazyFox ddef dstate =  ChangeLazyFox PFoxID (GetFormatDialogInfo ddef) dstate;

/*	Aux. function: Transforms the undo-removed info into clipboard format, in order to paste it
	into the text.
	Note: the removed info consists of a part removed before the cursor and a part removed behind
	the cursor. The latter is reversed. */

RemovedToClipboard	:: !Removed -> Clipboard;
RemovedToClipboard {Removed | before=Nil,	after		} = Reverse after;
RemovedToClipboard {Removed | before	,	after=Nil	} = before;
RemovedToClipboard {Removed | before	,	after		} = RemovedToClipboard2 before (Reverse after);
	
RemovedToClipboard2	:: !(List String) !(List String) -> Clipboard;
RemovedToClipboard2 (line:!Nil) (faft:!raft)
	=  (line +++ faft) :! raft;
RemovedToClipboard2 (fbef:!rbef) aft
	=  fbef :! RemovedToClipboard2 rbef aft;
